import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:mobile_scanner/mobile_scanner.dart';
import 'package:zcart_delivery/providers/order_provider.dart';

class ScanQrCodePage extends ConsumerWidget {
  final int orderId;
  final String orderNumber;
  final int customerId;

  const ScanQrCodePage({
    super.key,
    required this.orderId,
    required this.orderNumber,
    required this.customerId,
  });

  @override
  Widget build(BuildContext context, ref) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('Scan QR Code to Deliver'),
        shape: const RoundedRectangleBorder(borderRadius: BorderRadius.zero),
      ),
      body: MobileScanner(
        controller: MobileScannerController(
          detectionSpeed: DetectionSpeed.noDuplicates,
        ),
        onDetect: (capture) async {
          final List<Barcode> barcodes = capture.barcodes;
          if (barcodes.isNotEmpty) {
            final String? value = barcodes.first.rawValue;
            if (value != null) {
              String qrOrderData = "${orderId}_${orderNumber}_$customerId";

              if (value == qrOrderData) {
                ScaffoldMessenger.of(context).showSnackBar(
                  const SnackBar(
                    content: Text("Valid QR Code. Updating status..."),
                    duration: Duration(seconds: 3),
                  ),
                );
                await Future.delayed(const Duration(seconds: 2));
                await OrderController.updateStatus(orderId, 6).then((result) {
                  if (result == true) {
                    ref.invalidate(orderProvider(orderId));
                    ref.invalidate(ordersProvider);
                    ScaffoldMessenger.of(context).showSnackBar(
                      const SnackBar(
                        content: Text("Order status updated successfully"),
                        duration: Duration(seconds: 3),
                      ),
                    );
                  } else {
                    ScaffoldMessenger.of(context).showSnackBar(
                      const SnackBar(
                        content: Text("Failed to update order status"),
                        duration: Duration(seconds: 3),
                      ),
                    );
                  }
                });
                await Future.delayed(const Duration(seconds: 2)).then((value) {
                  Navigator.pop(context);
                });
              } else {
                showDialog(
                  context: context,
                  builder: (context) => AlertDialog(
                    title: const Text('INVALID Order QR Code'),
                    content: const Text(
                        'The order QR code is invalid for this order. Please recheck the order details and try again.'),
                    actions: [
                      TextButton(
                        onPressed: () {
                          Navigator.pop(context);
                          Navigator.pop(context);
                        },
                        child: const Text('OKAY'),
                      )
                    ],
                  ),
                );
              }
            } else {
              showDialog(
                context: context,
                builder: (context) => AlertDialog(
                  title: const Text('No QR Code Detected'),
                  content: const Text('Please try again'),
                  actions: [
                    TextButton(
                        onPressed: () {
                          Navigator.pop(context);
                          Navigator.pop(context);
                        },
                        child: const Text('OKAY'))
                  ],
                ),
              );
            }
          } else {
            showDialog(
              context: context,
              builder: (context) => AlertDialog(
                title: const Text('No QR Code Detected'),
                content: const Text('Please try again'),
                actions: [
                  TextButton(
                      onPressed: () => Navigator.pop(context),
                      child: const Text('OK'))
                ],
              ),
            );
          }
        },
      ),
    );
  }
}
